/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tv.mapper.mapperbase.world.level.block.CustomBlock;
import tv.mapper.mapperbase.world.level.block.ToolTiers;
import tv.mapper.mapperbase.world.level.block.ToolTypes;

public class ConeBlock
extends CustomBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape CONE_BASE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    private static final VoxelShape CONE1 = Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    private static final VoxelShape CONE2 = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape CONE3 = Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape CONE4 = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
    private static final VoxelShape CONE5 = Block.m_49796_((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape CONE = Shapes.m_83110_((VoxelShape)CONE_BASE, (VoxelShape)Shapes.m_83110_((VoxelShape)CONE1, (VoxelShape)Shapes.m_83110_((VoxelShape)CONE2, (VoxelShape)Shapes.m_83110_((VoxelShape)CONE3, (VoxelShape)Shapes.m_83110_((VoxelShape)CONE4, (VoxelShape)CONE5)))));
    private static final VoxelShape CONE_COL = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)10.0, (double)18.0, (double)10.0);
    private static final VoxelShape BARREL_BASE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final VoxelShape BARREL_MAIN = Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    private static final VoxelShape BARREL_HANDLE = Block.m_49796_((double)5.0, (double)14.0, (double)7.0, (double)11.0, (double)16.0, (double)9.0);
    private static final VoxelShape BARREL = Shapes.m_83110_((VoxelShape)BARREL_BASE, (VoxelShape)Shapes.m_83110_((VoxelShape)BARREL_MAIN, (VoxelShape)BARREL_HANDLE));
    private static final VoxelShape BARREL_COL = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)18.0, (double)11.0);
    private static final VoxelShape BOLLARD_BOTTOM = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0);
    private static final VoxelShape BOLLARD_BASE = Block.m_49796_((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    private static final VoxelShape BOLLARD_PORT = Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape BOLLARD = Shapes.m_83110_((VoxelShape)BOLLARD_BOTTOM, (VoxelShape)Shapes.m_83110_((VoxelShape)BOLLARD_BASE, (VoxelShape)BOLLARD_PORT));
    private static final VoxelShape BOLLARD_COL = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)18.0, (double)10.0);
    private EnumConeType type;

    public ConeBlock(BlockBehaviour.Properties properties, ToolTypes tool, EnumConeType type) {
        super(properties, tool);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ConeBlock(BlockBehaviour.Properties properties, ToolTypes tool, ToolTiers tier, EnumConeType type) {
        super(properties, tool, tier);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch (this.type) {
            case CONE: {
                return CONE;
            }
            case BARREL: {
                return BARREL;
            }
            case BOLLARD: {
                return BOLLARD;
            }
        }
        return CONE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch (this.type) {
            case CONE: {
                return CONE_COL;
            }
            case BARREL: {
                return BARREL_COL;
            }
            case BOLLARD: {
                return BOLLARD_COL;
            }
        }
        return CONE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return ConeBlock.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState FluidState2 = context.m_43725_().m_6425_(blockpos);
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static enum EnumConeType implements StringRepresentable
    {
        CONE(0, "cone"),
        BARREL(1, "barrel"),
        BOLLARD(2, "bollard");

        private final int id;
        private final String name;

        private EnumConeType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

